<?php 

	require "config.php";
	
	if(isset($_COOKIE['id'])){
		
		// Idő vizsgálata
		if(date('H') < 12){
			
			$szoveg = "Szép napot!";
			
		}
		else{
			
			$szoveg = "Szép estét!";
			
		}
		
	}
	else{
		header("Location: login.php");
	}

?>
<!DOCTYPE html>
<html lang="hu">
	<head>
		<!-- TITLE -->
		<title>Scholafy</title>
		
		<!-- METAS -->
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		
		<!-- STYLE -->
		<link rel="stylesheet" href="css/style.css">
		
		<!-- GOOGLE FONTS -->
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans+Arabic:wght@100&family=Nunito+Sans:opsz@6..12&display=swap" rel="stylesheet">
		
		<!-- FONT AWESOME -->
		<script src="https://kit.fontawesome.com/086e7cefb3.js" crossorigin="anonymous"></script>
		
		<!-- REFRESHER -->
		<!-- <meta http-equiv="refresh" content="2"> -->
	</head>
	<body>
		<div class="side-menu">
			 <div class="menu">
				<ul>
					<li><a href="#"><i class="fa-solid fa-house"></i></a></li>
					<li><a href="kereses.php"><i class="fa-solid fa-magnifying-glass"></i></a></li>
				</ul>
			 </div>
			 <div class="playlists">
				<ul>
					<li><a href="#"><i class="fa-solid fa-book"></i></a></li>
					<li><a href="favs.php" title="Kedvencek"><i class="fa-solid fa-heart"></i></a></li>
					<li><a href="#" onclick="newPlaylist()" title="Új lista létrehozása"><i class="fa-solid fa-plus"></i></a></li>
				</ul>
			 </div>
		</div>
		<div class="content-box">
			<div class="content-header">
				<h1><?= $szoveg; ?><a><?= $_COOKIE['username']; ?></a></h1>
				<div class="user-playlists">
					<div class="playlist">
						<img src="img/fav.png">
						<div class="playlist-name">
							<a href="favs.php">Kedvencek</a>
						</div>
					</div>
					<div class="playlist">
						<img src="img/playlist.png">
						<div class="playlist-name">
							<a>Lista neve</a>
						</div>
					</div>
				</div>
			</div>
			<div class="news">
				<h1>Újdonságok</h1>
				<div class="new-songs">
					<?php 
						$lekerdezes = "SELECT * FROM music ORDER BY id DESC";
						$talalt = $conn->query($lekerdezes);
						while($zene=$talalt->fetch_assoc()){
							
							$lekerdezes = "SELECT * FROM artists WHERE id=$zene[artistid]";
							$t_zenesz = $conn->query($lekerdezes);
							$zenesz = $t_zenesz->fetch_assoc();
					?>
						<a href="#"><div class="new-song">
							<img src="img/<?= $zene['img_name'];?>">
							<div class="info">
								<p class="name"><?= $zene['name'];?></p>
								<p class="artist"><?= $zenesz['username']; ?></p>
							</div>
						</div></a>
					<?php } ?>
					
				</div>
			</div>
		</div>
	</body>
</html>